#!/usr/bin/python2.4

import sys
import math


# Takes a frequency file and returns a list of
# (word,frequency) pairs
def fromfile(file):
    freq = []
    for line in file:
	wordfreq = line.split()
	wordfreq[1] = float(wordfreq[1])
	freq.append(wordfreq)
    return freq


# Takes a list of (word, frequency) pairs
# and returns a dictionary with words as keys
# and normalized frequencies as values
def normalize(freqlist):
    denominator = 0
    for (word,freq) in freqlist:
	denominator += freq * freq
    denominator = math.sqrt(denominator)

    normdict = {}
    for (word,freq) in freqlist:
	normdict[word]= freq / denominator
    
    return normdict


# Open files
file1 = open(sys.argv[1])
file2 = open(sys.argv[2])

# Convert to a list of (word,frequency) pairs
freq1 = fromfile(file1)
freq2 = fromfile(file2)

# Normalize
normfreq1 = normalize(freq1)
normfreq2 = normalize(freq2)

# Make sure that both dictionaries have the same set of keys
# (keys present in A but not in B will have a normalized
# frequency of 0 in B)
for key in normfreq1.keys():
    if not key in normfreq2:
	normfreq2[key]=0
for key in normfreq2.keys():
    if not key in normfreq1:
	normfreq1[key]=0

# Compute distance
diffsum = 0
for key in normfreq1.keys():
    diff = normfreq1[key]-normfreq2[key]
    diff = diff * diff
    diffsum += diff

print math.sqrt(diffsum)