#!/opt/local/bin/python2.5
# distance - compute the distance between two vector files

from __future__ import with_statement
import sys, math

def dot(a,b):
    "dot product"
    return sum([a[k] * b[k] for k in set(a.keys()) & set(b.keys())])

def parse_vector_file(name):
    "read a vector file"
    def parse_coordinate_line(line):
        a,b = line.split()
        return (a,float(b))
    with file(name) as f:
        return dict([parse_coordinate_line(line) for line in f])

# read two arguments as vector files
x,y = [parse_vector_file(name) for name in sys.argv[1:3]]

# compute distance between normalized vectors via simplified dot-product
print math.sqrt(2.0-2.0*dot(x,y)/math.sqrt(dot(x,x)*dot(y,y))) 