#!/usr/bin/python2.4
# distance - compute the distance between two vector files
    
import sys, math
    
def dot(a,b):
    "dot product"
    return sum([a[k] * b[k] for k in set(a.keys()) & set(b.keys())])
    
def normalize(d):
    "normalize a vector"
    q = math.sqrt(dot(d,d))
    return dict([(k,d[k]/q) for k in d])
    
def parse_vector_file(file):
    "read a vector file"
    def parse_coordinate_line(line):
        a,b = line.split()
        return (a,float(b))
    return dict([parse_coordinate_line(line) for line in open(file)])
    
# read two arguments as normalized vector files
x,y = [normalize(parse_vector_file(file)) for file in sys.argv[1:3]]
    
# compute distance between two unit vectors
print math.sqrt(2.0-2.0*dot(x,y)) 

# Note that |x,y| = sqrt(<x-y,x-y>), where <.,.> is the dot product.  This simplifies to
# sqrt(<x,x> - 2<x,y> + <y,y>) since <.,.> is bilinear and commutative.  If x and y are
# unit vectors, <x,x> = <y,y> = 1, so this further simplifies to sqrt(2.0 - 2.0 * <x,y>).