#ifndef _DYNAMICARRAY_H_
#define _DYNAMICARRAY_H_

#include<iostream>
using namespace std;

class DynamicArray
{
	private:
	    int *a; // Array 
		int s; // Array size

		int grow(int s2);
	
    public:
    	static const int EMPTY = -1;

    	static const int GROW_OK = 0;
    	
    	static const int SET_OK_NOGROW = 0;
    	static const int SET_OK_GROW = 1;
    	static const int SET_ERROR_NEGPOS = 2;
    	static const int SET_ERROR_NEGVALUE = 3;

    	static const int GET_OK = 0;
    	static const int GET_ERROR_BADPOS = 1;
    	
		// Constructors

		/* Creates an empty array (size 0) */
		DynamicArray();

		/* Creates an array of size "s" */
		DynamicArray(int s);

		/* Initializes the array with the values of another array. The
		 * constructor receives "a2" (the 'source array') and its size.*/
		DynamicArray(int *a2, int s2);

		/* Copy constructor. */
		DynamicArray(const DynamicArray &da);

		/* Destructor. */
		~DynamicArray();

		int getSize();

		/* Modifies the values in position "pos" with new value "v".
		 * Must return the following:
		 *   0: Success. Did not need to grow the array.
		 *   1: Success. Had to grow the array.
		 *   2: Error. Specified position is < 0
		 *   3: Error. Specified value is < 0
		 */
		int setValue(int pos, int v);

		/* Returns the value in position "pos" using parameter "v".
		 * The function must return the following:
		 *   0: Success.
		 *   1: Error. A bad position was specified.
		 */
		int getValue(int pos, int &v) const;


		/* Assignment operator overload */
		DynamicArray& operator=(const DynamicArray &da2);

		/* Equality operator overload.
		 * Returns true if both DynamicArrays are the same. We assume
		 * that two DynamicArrays are the same if (a) they have the same 
		 * size and (b) they have the same value in every position. */
		bool operator==(const DynamicArray &da2) const;

		friend ostream& operator<<(ostream &os, DynamicArray &da);

		/* Bracket operator overload. */
		int& operator[](int pos);
		int operator[](int pos) const;
};

#endif //_DYNAMICARRAY_H_
